/**
 * Beschrijft een papierlade van een kopieertoestel.
 *
 * @author Dominiek Vandewalle
 * @version 2014-12-03
 */
public class Papierlade
{
    private String papiertype;
    private int aantalbladen;

    /**
     * Constructor voor objecten van de klasse Papierlade.
     * @param   type    Type van de bladen in deze papierlade (A3, A4, ...).
     */
    public Papierlade(String papiertype)
    {
        this.papiertype = papiertype;
    }
    
    /**
     * Geeft het type van het papier in de printlade terug.
     * @return  Het papiertype van het papier in deze lade.
     */
    public String getPapiertype()
    {
       return papiertype;
    }
   
    /**
     * Geeft het aantal bladen in de papierlade terug.
     * @return  Het aantal bladen in de papierlade.
     */
    public int getAantalbladen()
    {
       return aantalbladen;
    }
    
    /**
     * Vult het papier in de papierlade aan. Het papier is van het gewenste papiertype.
     * @param   aantal  Het aantal bladen waarmee de papierlade bijgevuld wordt.
     */
    public void vulPapierladeBij(int aantal)
    {
       this.aantalbladen += aantal;
    }
    
    /**
     * Neemt een aantal bladen weg uit de papierlade.
     * @param   aantal  Het aantal bladen dat weggenomen wordt (door een kopieertoestel).
     */
    public void neemBladen(int aantal)
    {
        aantalbladen -= aantal;
    }
    
    /**
     * Test of het papiertype van de papierlade gelijk is aan het opgegeven papiertype.
     * @param   papiertype    Het papiertype waarmee je het type van deze papierlade wil vergelijken.
     * @return  Indien het papiertype van deze papierlade gelijk is aan het opgegeven papiertype, true. Anders false.
     */
    public boolean checkPapiertype(String papiertype)
    {
        return this.papiertype.equals(papiertype);
    }
}
